<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="./Controller/index.js" defer></script>
    <link rel="stylesheet" href="./Style/style.css">
    <title>Mini blog de mode</title>
</head>

<body>
    <section class="hero_section">
        <header>
            <!-- Logo utilisateur connecté -->
            <?php if (connected_user()): ?>
                <div class="logo">
                    <img src="./uploads/<?= htmlspecialchars(user_pp_current($_SESSION['user_id'])); ?>" alt="Photo de profil">
                </div>
            <?php endif; ?>

            <!-- Navigation -->
            <nav>
                <ul>
                    <li><a href="index.php?action=home">Accueil</a></li>
                    <li><a href="index.php?action=showArchives">Archives</a></li>
                    <?php if (isAdmin()): ?>
                        <li><a href="index.php?action=precreate_post">Ajouter un Billet</a></li>
                        <li><a href="index.php?action=administration">Administration</a></li>
                    <?php endif; ?>
                </ul>
            </nav>

            <!-- Navigation droite -->
            <div class="right-nav">
                <ul>
                    <?php if (connected_user()): ?>
                        <li><a href="index.php?action=profile">Mon Profil</a></li>
                    <?php else: ?>
                        <li><a href="index.php?action=login">Connexion</a></li>
                        <li><a href="index.php?action=inscription">Inscription</a></li>
                    <?php endif; ?>
                </ul>
            </div>
        </header>

        <!-- Texte de la section Héros -->
        <div class="hero_text_container">
            <div class="hero_title_container">
                <h1>Un blog sur la mode</h1>
                <p>
                  Bienvenue, sur le mini blog sur la mode ! 
                  Crée dans un cadre scolaire par Anastasia Gawryluk. Bonne lecture ! 
                </p>
            </div>
            <div class="hero_img_container">
                <img src="/assets/photo_accueil_mode.jpg" alt="">
            </div>
        </div>
    </section>

        <!-- Section des articles -->
        <section class="blog_section">
            <?php 
            $lastPosts = latest_posts(); 
            if (!empty($lastPosts)): 
                foreach ($lastPosts as $post): ?>
                    <a class="linkBlog" href="index.php?action=blogDetails&id=<?= intval($post['id_billets']); ?>">
                        <div class="post" id="<?= intval($post['id_billets']); ?>">
                            <h2><?= htmlspecialchars($post['titre']); ?></h2>
                            <p class="post-content"><?= htmlspecialchars($post['contenu']); ?></p>
                            <span>Voir plus</span>
                            <small>Posté le : <?= htmlspecialchars($post['date_post']); ?></small>
                        </div>
                    </a>
                <?php endforeach; 
            else: ?>
                <p>Aucun article récent disponible.</p>
            <?php endif; ?>
        </section>

    </main>
</body>

</html>
