<?php
session_start();

// Affichage des erreurs pour le debug
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Inclusion du modèle
require_once('Model/model.php');

// Récupération de l'action à partir de l'URL
$action = $_GET['action'] ?? '';

// Traitement des actions selon le cas
switch ($action) {
    case 'inscription':
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if ($_POST['mot_de_passe'] !== $_POST['confirmer_mot_de_passe']) {
                $error = 'Les mots de passe ne correspondent pas.';
                include('./Vue/inscription.php');
                exit;
            } elseif (registration_valid() === true) {
                register_users($_POST);
                include('./Vue/login.php');
                exit;
            }
        }
        include('./Vue/inscription.php');
        break;

    case 'login':
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && login_users($_POST)) {
            include('./Vue/home.php');
        } else {
            $error = 'Identifiants invalides';
            include('./Vue/login.php');
        }
        break;

    case 'inscrire':
        include('./Vue/inscription.php');
        break;

    case 'logout':
        session_unset();
        session_destroy();
        include('./Vue/home.php');
        break;

    case 'profile':
        if (connected_user()) {
            include('./Vue/profile.php');
        }
        break;

    case 'home':
        include('./Vue/home.php');
        break;

    case 'administration':
        isAdmin() ? include('./Vue/backoffice.php') : include('./Vue/login.php');
        break;

    case 'showArchives':
        include('./Vue/archives.php');
        break;

    case 'precreate_post':
        isAdmin() ? include('./Vue/post.php') : include('./Vue/login.php');
        break;

    case 'create_post':
        if (isAdmin() && $_SERVER['REQUEST_METHOD'] === 'POST') {
            create_post($_POST['titre'], $_POST['contenu'], $_SESSION['user_id']);
            include('./Vue/home.php');
        } else {
            $error = "Une erreur est survenue lors de la création du billet";
            include('./Vue/login.php');
        }
        break;

    case 'delete_post':
        if (isAdmin() && isset($_GET['id'])) {
            delete_post(intval($_GET['id']));
            include('./Vue/archives.php');
        } else {
            include('./Vue/login.php');
        }
        break;

    case 'deleteUser':
        if (isAdmin() && isset($_GET['id'])) {
            delete_users(intval($_GET['id']));
            include('./Vue/backoffice.php');
        } else {
            include('./Vue/login.php');
        }
        break;

    case 'update_users':
        if (isAdmin() && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['id'])) {
            update_users(intval($_GET['id']), [
                'login' => $_POST['login'],
                'prenom' => $_POST['prenom'],
                'nom' => $_POST['nom']
            ]);
            include('./Vue/backoffice.php');
        } else {
            include('./Vue/login.php');
        }
        break;

    case 'update_post':
        if (isAdmin() && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['id'])) {
            update_post($_GET['id'], [
                'titre' => $_POST['titre'],
                'contenu' => $_POST['contenu'],
                'auteur_id' => $_POST['auteur_id']
            ]);
            include('./Vue/backoffice.php');
        }
        break;

    case 'blogDetails':
        $id_post = $_GET['id'];
        $post = post_id($id_post);
        $comments = show_comments($id_post);
        include('./Vue/blogDetails.php');
        break;

    case 'comment_post':
        if (connected_user() && $_SERVER['REQUEST_METHOD'] === 'POST') {
            $id_post = $_GET['id'];
            $content_comments = $_POST['content_comments'];
            $userId = $_SESSION['user_id'];

            if (!empty($id_post) && !empty($userId) && !empty($content_comments) && comment_post($id_post, $userId, $content_comments)) {
                $comments = show_comments($id_post);
                $post = post_id($id_post);
                include("./Vue/blogDetails.php");
            } else {
                $echecAjout = "Erreur : Échec de l'ajout du commentaire.";
            }
        }
        break;

    case 'delete_comments':
        if (isAdmin() && isset($_GET['id'])) {
            delete_comments(intval($_GET['id']));
            include('./Vue/archives.php');
        } else {
            $error = "Vous n'avez pas les permissions.";
        }
        break;

    case 'update_comments':
        if (isAdmin() && isset($_GET['id']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
            update_comments(intval($_GET['id']), ['contenu' => $_POST['contenu']]);
            include('./Vue/backoffice.php');
        }
        break;

    case 'upload':
        if (connected_user()) {
            $target_dir = "./uploads/";
            $imageFileType = strtolower(pathinfo($_FILES["photo_profil"]["name"], PATHINFO_EXTENSION));
            $id_personne = $_SESSION['user_id'];
            $uniqueFileName = $id_personne . "_" . time() . "." . $imageFileType;
            $target_file = $target_dir . $uniqueFileName;

            $uploadOk = 1;

            if ($_FILES["photo_profil"]["error"] != 0) {
                $error = "Erreur lors de l'upload du fichier.";
                $uploadOk = 0;
            }

            if ($_FILES["photo_profil"]["size"] > 500000) {
                $volumineux = "Votre fichier est trop volumineux.";
                $uploadOk = 0;
            }

            if (!in_array($imageFileType, ["jpg", "jpeg", "png"])) {
                $format = "Seuls les fichiers JPG, JPEG, PNG sont autorisés.";
                $uploadOk = 0;
            }

            if ($uploadOk == 1 && move_uploaded_file($_FILES["photo_profil"]["tmp_name"], $target_file)) {
                $oldFileName = user_pp_current($id_personne);
                if ($oldFileName && file_exists($target_dir . $oldFileName)) {
                    unlink($target_dir . $oldFileName);
                }
                upload_user_pp($uniqueFileName, $id_personne);
            } else {
                $erreurUpload = "Erreur lors du téléchargement de votre fichier.";
            }
        }
        include('./Vue/profile.php');
        break;

    default:
        include('./Vue/home.php');
        break;
}
