<?php
include("connexion.php");

// Vérifier si le formulaire a été soumis
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // Vérifier si les champs requis sont définis
    if (
        isset($_POST['prenom']) && isset($_POST['nom']) && isset($_POST['numtel']) &&
        isset($_POST['mail']) && isset($_POST['salle']) && isset($_POST['nombre_personnes']) &&
        isset($_POST['date_reservation'])
    ) {

        // Récupérer les données du formulaire
        $prenom = htmlspecialchars($_POST['prenom']);
        $nom = htmlspecialchars($_POST['nom']);
        $numtel = htmlspecialchars($_POST['numtel']);
        $mail = htmlspecialchars($_POST['mail']);
        $salle = intval($_POST['salle']);
        $nombre_personnes = intval($_POST['nombre_personnes']);
        $date_reservation = htmlspecialchars($_POST['date_reservation']);

        // Récupérer le prix par personne depuis la table salles
        $stmt_prix = $db->prepare("SELECT prix_par_personne FROM salles WHERE id_salles = :salle");
        $stmt_prix->bindParam(':salle', $salle, PDO::PARAM_INT);
        $stmt_prix->execute();
        $prix_data = $stmt_prix->fetch(PDO::FETCH_ASSOC);

        // Vérifier si la requête a renvoyé des résultats
        if ($prix_data) {
            $prix_par_personne = $prix_data['prix_par_personne'];
        } else {
            // Gérer le cas où la salle sélectionnée n'existe pas
            exit("La salle sélectionnée n'existe pas.");
        }
        $stmt_prix->closeCursor();

        // Calculer le prix total
        $prix_total = $prix_par_personne * $nombre_personnes; // Prix total

        try {
            // Insérer le client
            $stmt_client = $db->prepare("INSERT INTO client (nom, prenom, numero_tel, mail) VALUES (:nom, :prenom, :numtel, :mail)");
            $stmt_client->bindParam(':nom', $nom);
            $stmt_client->bindParam(':prenom', $prenom);
            $stmt_client->bindParam(':numtel', $numtel);
            $stmt_client->bindParam(':mail', $mail);
            $stmt_client->execute();
            $client_id = $db->lastInsertId();

            // Insérer la réservation
            $date = date("Y-m-d"); // Date actuelle pour le champ 'date'
            $stmt_reservation = $db->prepare("INSERT INTO reservation (ext_salles, ext_client, date, date_reservation, nombre_personnes, prix_total) VALUES (:salle, :client_id, :date, :date_reservation, :nombre_personnes, :prix_total)");
            $stmt_reservation->bindParam(':salle', $salle);
            $stmt_reservation->bindParam(':client_id', $client_id);
            $stmt_reservation->bindParam(':date', $date);
            $stmt_reservation->bindParam(':date_reservation', $date_reservation);
            $stmt_reservation->bindParam(':nombre_personnes', $nombre_personnes);
            $stmt_reservation->bindParam(':prix_total', $prix_total);
            $stmt_reservation->execute();
            $reservation_id = $db->lastInsertId();

            // Rediriger vers la page de confirmation avec l'id de la réservation
            header("Location: confirmation.php?id_reservation=" . $reservation_id);
            exit();
        } catch (PDOException $e) {
            die('Erreur : ' . $e->getMessage());
        }
    } else {
        // Gérer le cas où des champs requis ne sont pas définis dans le formulaire
        exit("Des champs requis ne sont pas définis dans le formulaire.");
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Réservation</title>
    <link rel="stylesheet" href="EscapeMystere.css">
   

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Stick+No+Bills:wght@200..800&display=swap" rel="stylesheet">
</head>

<body>

    <!--BARRE DE NAVIGATION TOP-->
    <header>
        <nav class="top-nav">
        <a href="#main" class="skip-link">Aller au contenu</a>
            <div>
                <a href="index.html">
                    <img src="Images/logo.png" alt="logo">
                </a>
            </div>
            <ul class="contenu">
                <li><a href="index.php">Accueil</a></li>
                <li><a href="salles.php">Salles</a></li>
                <li><a href="Qui_sommes_nous.html">Qui sommes nous ?</a> </li>
            </ul>
        </nav>
    </header>


    
    <section>
        <h1 class="titre">RÉSERVATION</h1>
        <main role="main" id="main" tabindex="-1">
        <!-- FORMULAIRE -->
        <div class="form">
    <form action="reservation.php" method="post">
        <div class="form-group">
        <p class="legende">Les champs marqués d'un astérisque (*) sont obligatoires.</p>
            <ul>
                <li>
                    <label for="prenom">Prénom * :</label>
                    <input type="text" id="prenom" name="prenom"/>
                </li>
                <li>
                    <label for="nom">Nom * :</label>
                    <input type="text" id="nom" name="nom" />
                </li>
                <li>
                    <label for="numero_tel">Numéro de téléphone * :</label>
                    <input type="tel" id="numero_tel" name="numtel" placeholder="10 chiffres"  required pattern="[0-9]{10}" title="Le numéro de téléphone doit contenir 10 chiffres"/>
                </li>
                <li>
    <label for="mail">Mail * :</label>
    <input type="email" id="mail" name="mail" placeholder="exemple@mail.com" required pattern="[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}" title="Veuillez entrer une adresse email valide contenant un @" />
</li>
                <li>
                    <label for="salle">Salle *:</label>
                    <select id="salle" name="salle" required>
                        <?php
                        try {
                            // Récupération des salles
                            $requete_salles = "SELECT id_salles, nom FROM salles";
                            $stmt_salles = $db->query($requete_salles);
                            while ($salle = $stmt_salles->fetch(PDO::FETCH_ASSOC)) {
                                echo "<option value=\"" . htmlspecialchars($salle['id_salles']) . "\">" . htmlspecialchars($salle['nom']) . "</option>";
                            }
                        } catch (PDOException $e) {
                            echo "Erreur : " . $e->getMessage();
                        }
                        ?>
                    </select>
                </li>
                <li>
                    <label for="nombre_personnes">Nombre de personnes * :</label>
                    <select id="nombre_personnes" name="nombre_personnes" required>
                        <option value="2">2 personnes</option>
                        <option value="3">3 personnes</option>
                        <option value="4">4 personnes</option>
                        <option value="5">5 personnes</option>
                    </select>
                </li>
                <li>
                    <label for="date_reservation">Date de réservation * :</label>
                    <input type="date" id="date_reservation" name="date_reservation" required />
                </li>
                <input class="btn" type="submit" value="Envoyer">
                <p id="confirmation"></p>
            </ul>
        </div>
    </form>
                    </main>
</div>
    </section>


  

    <!--BARRE DE NAVIGATION BOTTOM-->
    <footer>
        <nav class="bottom-nav">
            <ul>
                <li><a href="faq.html">FAQ</a></li>
                <li><a href="plan_du_site.html">Plan du site</a></li>
                <li><a href="mentions_legales.html">Mentions légales</a></li>
            </ul>
        </nav>
    </footer>




</body>
</html>