<?php
include("connexion.php");

// Fonction pour trier les salles par nom
function trierParNom($a, $b) {
    return strcmp($a['nom'], $b['nom']);
}

// Fonction pour trier les salles par niveau
function trierParNiveau($a, $b) {
    return $a['niveau'] - $b['niveau'];
}

// Fonction pour trier les salles par thème
function trierParTheme($a, $b) {
    return strcmp($a['theme'], $b['theme']);
}

// Requête SQL de base pour récupérer les salles d'escape game
$requete = "SELECT * FROM salles";

// Appliquer le filtre par niveau si spécifié
$conditions = array();
$params = array();

$niveau = isset($_GET['niveau']) ? $_GET['niveau'] : '';
if (!empty($niveau)) {
    $conditions[] = "niveau = :niveau";
    $params[':niveau'] = $niveau;
}

// Appliquer le filtre par recherche de nom si spécifié
$search = isset($_GET['search']) ? $_GET['search'] : '';
if (!empty($search)) {
    $conditions[] = "nom LIKE :search";
    $params[':search'] = '%' . $search . '%';
}

if (count($conditions) > 0) {
    $requete .= " WHERE " . implode(" AND ", $conditions);
}

// Préparer et exécuter la requête SQL
$stmt = $db->prepare($requete);
foreach ($params as $key => &$value) {
    $stmt->bindParam($key, $value);
}
$stmt->execute();
$resultat = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fonction pour récupérer les salles d'escape game
function getSallesEscapeGame($resultat) {
    $salles = array();
    foreach ($resultat as $ligne) {
        $salles[] = $ligne;
    }
    return $salles;
}

$salles = getSallesEscapeGame($resultat);

// Vérifier si $salles est défini et est un tableau
if (isset($salles) && is_array($salles)) {
    if (isset($_GET['tri'])) {
        $tri = $_GET['tri'];
        if ($tri == 'nom') {
            usort($salles, 'trierParNom');
        } elseif ($tri == 'niveau') {
            usort($salles, 'trierParNiveau');
        } elseif ($tri == 'theme') {
            usort($salles, 'trierParTheme');
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Salles</title>
    <link rel="stylesheet" href="salles.css">
    <link rel="stylesheet" href="EscapeMystere.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Stick+No+Bills:wght@200..800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Didact+Gothic&display=swap" rel="stylesheet">
</head>
<body>

    <!--BARRE DE NAVIGATION TOP-->
    <header>
    <nav class="top-nav">
    <a href="#main" class="skip-link">Aller au contenu</a>
        <a href="index.html">
            <img src="Images/logo.png" alt="logo">
        </a>
        <form action="salles.php" method="GET" class="search-form">
            <div class="search-container">
                <img src="Images/loupe.png" alt="Rechercher" class="search-icon">
                <input type="text" name="search" placeholder="Rechercher une salle" value="<?php echo htmlspecialchars($search); ?>">
            </div>
        </form>
        <ul class="contenu">
            <li><a href="index.php">Accueil</a></li>
            <li><a href="salles.php">Salles</a></li>
            <li><a href="Qui_sommes_nous.html">Qui sommes nous ?</a></li>
        </ul>
    </nav>
</header>
    

    <section>
        <h1 class="titre">SALLES</h1>
      

        <div class="tri-filtre">
            <!-- Formulaire de tri -->
            <form action="salles.php" method="GET" class="search-form">
                <label for="tri">Trier par :</label>
                <select name="tri">
                    <option value="nom">Nom</option>
                    <option value="niveau">Niveau</option>
                    <option value="theme">Thème</option>
                </select>
                <button type="submit" class="search-btn">Rechercher</button>
            </form>

            <!-- Formulaire de filtrage par niveau -->
            <form action="salles.php" method="GET" class="filter-form">
                <label for="niveau">Filtrer par niveau :</label>
                <select id="niveau" name="niveau">
                    <option value="">Tous</option>
                    <option value="1">Niveau 1</option>
                    <option value="2">Niveau 2</option>
                    <option value="3">Niveau 3</option>
                    <option value="4">Niveau 4</option>
                    <option value="5">Niveau 5</option>
                </select>
                <button type="submit" class="search-btn">Rechercher</button>
            </form>
        </div>
  
        
        <main role="main" id="main" tabindex="-1">
    <div class="containersalles">
        <?php
            foreach ($salles as $salle) {
                echo "<div class='card'>";
                $imagePath = 'images/' . ($salle['image']);
                echo "<img src='" . $imagePath . "' alt='Image de la salle " . ($salle['nom']) . "' class='card-image'>";
                echo "<div class='card-content'>";
                echo "<h2>" . $salle['nom'] . "</h2>";
                echo "<p>" . $salle['description'] . "</p>";
                echo "<br>";
                echo "<p>Prix par joueur: " . $salle['prix_par_personne'] . "</p>";
                echo "<p>Lieu: " . $salle['lieu'] . "</p>";
                echo "<p>Thème: " . $salle['theme'] . "</p>";
                echo "<p>Nombre de joueurs max: " . $salle['nombre_de_joueurs_max'] . "</p>";
                echo "<p>Nombre de joueurs min: " . $salle['nombre_de_joueurs_min'] . "</p>";
                echo "<p>Niveau: " . $salle['niveau'] . "</p>";
                echo "<p>Âge minimum: " . $salle['age_min'] . "</p>";
                echo "<p>Durée: " . $salle['duree'] . "</p>";
                echo "<p><a href='reservation.php?id=" . $salle['id_salles'] . "' class='btn'>Réserver</a></p>";
                echo "</div>";
                echo "</div>";
            }
        ?>
    </div>
    </main>
    </section>






    <footer>
        <nav class="bottom-nav">
            <ul>
                <li><a href="faq.html">FAQ</a></li>
                <li><a href="plan_du_site.html">Plan du site</a></li>
                <li><a href="mentions_legales.html">Mentions légales</a></li>
            </ul>
        </nav>
    </footer>
</body>
</html>
